import java.io.*;

public class InputFileTransformer {

	public static void main(String[] args) throws Exception {
	
		if (args.length < 2) {
			System.out.println("Usage: java InputFileTransformer input-file output-file");
			System.exit(-1);
		}
		
		String inputFile = args[0];
		String outputFile = args[1];
		
		BufferedReader reader = new BufferedReader(new FileReader(inputFile));
		PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
		
		try {
		
			String firstLine = reader.readLine();
			if (firstLine == null) {
				System.out.println("ERROR: Input file is empty");
				System.exit(-1);
			}

			String[] labels = firstLine.split("\t");
			if (labels.length == 0) {
				System.out.println("ERROR: First line of input file must contain all the labels");
				System.exit(-1);
			}
			writer.println(firstLine);

			int labelCount = labels.length - 1;
			System.out.println(">> Processing " + labelCount + " labels in input file.");

			// Process each line in the input file, rearrange it, and write two 
			// lines to output file.
			String line = reader.readLine();
			int sampleCount = 0;
			while (line != null) {
			
				sampleCount++;
			
				String[] segments = line.split("\t");

				// First line.
				writer.print(segments[0]);
				writer.print('\t');
				writer.print(segments[1]);
				writer.print('\t');
				for (int i = 2; i < segments.length; i++) {
					writer.print(segments[i].charAt(0));
					writer.print('\t');
				}
				writer.println();
			
				// Second line.
				writer.print('\t');
				writer.print('\t');
				for (int i = 2; i < segments.length; i++) {
					writer.print(segments[i].charAt(1));
					writer.print('\t');
				}
				writer.println();

				line = reader.readLine();
			}
			
			System.out.println(">> Wrote " + sampleCount + " samples to output file.");
			
			
		} finally {
			if (reader != null) {
				try { 
					reader.close();
				} catch (Exception e1) {}
			}	
			
			if (writer != null) {
				try { 
					writer.close();
				} catch (Exception e1) {}
			}
		}
	
	}

}