#!/usr/bin/tcsh      
#
# automatic analysis of bisulphite generated methylation data
#
# parse filename with sequences in FASTA-format as parameter
# the script calls the programms of the MethTool-package and
# generates the recommended directory- and file structure
#
# call conversion program, writes the statistic into a .log file 
# and the profile into a .tab file
#
echo "Converting files. Please wait."
./convert_bisulfite.pl -f $1 > $1.log   
echo "Conversion done..."
#
#call analysis programs
#
./EvalLog.pl  -d . -n $1
echo "PCR or Sequencing errors and total base number filed."
./InfoScan.pl -d . -n $1
#
# make directories Seq1, Seq2, and Stat to sort files
#
mkdir Seq1
mv  *.seq1 Seq1
mkdir Seq2
mv  *.seq2 Seq2
mkdir Stat
mv  *.tab Stat
mv  *.log Stat
mv  *.inf Stat
mv  *.err Stat
echo "Seq1,Seq2 and Stat folders generated and relevant files moved..."
#
# call graphic programs
#
./Plot_CpGs_to_png.pl          -d Seq1 -n $1
# ./Plot_5mCpG_density_to_png.pl -d Seq1 -n MethTools_test (need fixing)
#
# clean up the rest
#
mv Seq1/*.png Stat

zip -rm $1.zip Seq1 Seq2 Stat $1

exit
